

import { validatedFetch } from "@/lib/zod/validated-fetch";
import { transformOtpLoggingResponse } from "./transformers";
import { OtpLoggingResponseSchema } from "../zod/otp-logging.schema";
import { env } from "@/env";

export async function fetchLogs(startDate: string, endDate: string) {
  const res = await validatedFetch({
    url: `${env.NEXT_PUBLIC_ANALYTICS_API_URL}/LoggingByDates/${startDate}/${endDate}`,
    schema: OtpLoggingResponseSchema,
  });

  if (res instanceof Error) {
    throw new Error('Failed to fetch OTP logs')
  }
  return transformOtpLoggingResponse(res)
}